/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.PETrace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultProblemMonitor
implements ProblemMonitor,
VetoableChangeListener,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XRVXDPMT";
    private static final String TRACE_MASKF = "XRVXDPMF";
    private static final String TRACE_MASKD = "XRVXDPMD";
    private boolean running = false;
    private List problems = null;
    private List problemsByType = null;
    private Map userData = null;

    public DefaultProblemMonitor() {
        Trace.trace(TRACE_MASKT, "<>DefaultProblemMonitor ctor");
    }

    public synchronized void clear() {
        this.problems = null;
        this.problemsByType = null;
    }

    public void init(Map userData) {
        this.userData = userData;
    }

    public synchronized void start() {
        Trace.trace(TRACE_MASKT, "->DefaultProblemMonitor.start()");
        PETrace.petrace(this.userData, "DefaultProblemMonitor.start");
        try {
            if (!this.running) {
                this.clear();
            }
            ProblemManager pm = ProblemManager.getProblemManager();
            pm.addVetoableChangeListener("ProblemOpenProperty", this);
            pm.addPropertyChangeListener("ProblemInventoryProperty", this);
            this.running = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "<-! DefaultProblemMonitor.start - exception caught and ignored: " + e);
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public synchronized boolean isStarted() {
        return this.running;
    }

    public synchronized List getDetectedProblems() {
        return this.problemsByType == null ? null : Collections.unmodifiableList(this.problemsByType);
    }

    public synchronized void stop() {
        Trace.trace(TRACE_MASKT, "<>DefaultProblemMonitor.stop");
        PETrace.petrace(this.userData, "DefaultProblemMonitor.stop");
        try {
            ProblemManager pm = ProblemManager.getProblemManager();
            pm.removeVetoableChangeListener("ProblemOpenProperty", this);
            pm.removePropertyChangeListener("ProblemInventoryProperty", this);
            this.running = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "<-! DefaultProblemMonitor.stop - exception caught and ignored: " + e);
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public synchronized void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Problem p = (Problem)evt.getOldValue();
        if (p == null) {
            p = (Problem)evt.getNewValue();
        }
        if (p == null || !(p instanceof CommonProblem)) {
            return;
        }
        CommonProblem cp = (CommonProblem)p;
        Trace.trace(TRACE_MASKF, "->DefaultProblemMonitor.vetoableChange() problem detected - refcode=" + cp.getRefcode());
        PETrace.petrace(this.userData, "DefaultProblemMonitor.vetoableChange() problem detected - refcode=" + cp.getRefcode());
        cp.setCallHome(false);
        try {
            this.testEvent(evt);
        }
        catch (PropertyVetoException pve) {
            Trace.trace(TRACE_MASKF, "<- DefaultProblemMonitor.vetoableChange() vetoed - not adding this problem to list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.vetoableChange() vetoed - not adding this problem to list");
            throw pve;
        }
        if (this.problems == null) {
            this.problems = new LinkedList();
            this.problemsByType = new LinkedList();
        }
        if (!this.problems.contains(p)) {
            Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.vetoableChange() adding problem to list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.vetoableChange() adding problem to list");
            this.problemsByType.add(new Object[]{p, ProblemMonitor.NEW_PROBLEM});
            this.problems.add(p);
        } else {
            Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.vetoableChange() skipping problem  - already in list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.vetoableChange() skipping problem  - already in list");
        }
        Trace.trace(TRACE_MASKF, "<- DefaultProblemMonitor.vetoableChange()");
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Problem p = (Problem)evt.getOldValue();
        if (p == null) {
            p = (Problem)evt.getNewValue();
        }
        if (p == null || !(p instanceof CommonProblem)) {
            return;
        }
        CommonProblem cp = (CommonProblem)p;
        Trace.trace(TRACE_MASKF, "->DefaultProblemMonitor.propertyChange() problem detected - refcode=" + cp.getRefcode());
        PETrace.petrace(this.userData, "DefaultProblemMonitor.propertyChange() problem detected - refcode=" + cp.getRefcode());
        try {
            this.testEvent(evt);
        }
        catch (PropertyVetoException pve) {
            Trace.trace(TRACE_MASKF, "<-DefaultProblemMonitor.propertyChange() vetoed - not adding this problem to list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.propertyChange() vetoed - not adding this problem to list");
            return;
        }
        if (this.problems == null) {
            this.problems = new LinkedList();
            this.problemsByType = new LinkedList();
        }
        if (!this.problems.contains(p)) {
            Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.propertyChange() adding problem to list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.propertyChange() adding problem to list");
            this.problemsByType.add(new Object[]{p, ProblemMonitor.DUP_PROBLEM});
            this.problems.add(p);
        } else {
            Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.propertyChange() skipping problem  - already in list");
            PETrace.petrace(this.userData, "DefaultProblemMonitor.propertyChange() skipping problem  - already in list");
        }
        Trace.trace(TRACE_MASKF, "<- DefaultProblemMonitor.propertyChange()");
    }

    protected void testEvent(PropertyChangeEvent evt) throws PropertyVetoException {
        List selectedFrus;
        if (this.userData != null && (selectedFrus = (List)this.userData.get("SELECTED_FRUS")) != null) {
            Iterator sfit = selectedFrus.iterator();
            while (sfit.hasNext()) {
                Object o = sfit.next();
                if (!(o instanceof VetoableChangeListener)) continue;
                String fruLoc = (String)((Fru)o).getProperties().get("LOCATION");
                Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.testEvent() FRU at location[" + fruLoc + "] is a VetoableChangeListener...calling vetoableChange()");
                PETrace.petrace(this.userData, "DefaultProblemMonitor.testEvent() FRU at location[" + fruLoc + "] is a VetoableChangeListener...calling vetoableChange()");
                try {
                    ((VetoableChangeListener)o).vetoableChange(evt);
                    Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.testEvent() PropertyVetoException NOT thrown from FRU class");
                    PETrace.petrace(this.userData, "DefaultProblemMonitor.testEvent() PropertyVetoException NOT thrown from FRU class");
                }
                catch (PropertyVetoException pve) {
                    Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.testEvent() PropertyVetoException thrown from FRU class");
                    Trace.trace(TRACE_MASKF, "DefaultProblemMonitor.testEvent() exception: " + pve);
                    Trace.trace(TRACE_MASKF, pve);
                    PETrace.petrace(this.userData, "DefaultProblemMonitor.testEvent() PropertyVetoException thrown from FRU class");
                    throw pve;
                }
            }
        }
    }
}

